#include <stdio.h>
#include <string.h>
#include <math.h>

#define ABS(A) ((A)<0?(-A):(A))
#define SIGN(A,B) ((B)>0?(A):(-A))

void compress(FILE *tmpf,float *x,int npt){

	int i,j,k,lnx,rem,i1 = 90,i2 = 8100,i3 = 729000;
	float at2t23 = 8388608., big=1.e28,small=1.e-28,aln2;
	char m[6];
	m[5]='\0';

	aln2 = log(2.);
	for(k=0 ; k<npt ; k++){
		if (x[k]==0.){
			m[4] = 80;
			m[3] = 0;
			m[2] = 0;
			m[1] = 0;
			m[0] = 0;
		}else{
			if (ABS(x[k])>big) x[k]= SIGN(big, x[k]);
			if (ABS(x[k])<small) x[k] = SIGN(small, x[k]);
			if (ABS(x[k])>=1.)
				lnx = (int)(log(ABS(x[k]))/aln2) + 129;
			else
				lnx = (int)(log(ABS(x[k]))/aln2) + 128;
			j = lnx/i1;
			m[3] = lnx - j*i1;
			lnx = lnx - 129;
			if (lnx>0)
				rem = (int)((ABS(x[k])/pow(2.,(double)(lnx)) - 1.)*at2t23);
			else
				rem = (int)((ABS(x[k])*pow(2.,(double)(ABS(lnx))) - 1.)*at2t23);
			m[4] = rem/i3;
			rem = rem - m[4]*i3;
			m[2] = rem/i2;
			rem = rem - m[2]*i2;
			m[1] = rem/i1;
			m[0] = rem - m[1]*i1;
			m[4] = m[4] + j*12;
			if (x[k]<0.) m[4] = m[4] + 40;
		}
		for (i=0;i<5;i++){
			m[i] = m[i] + 33;
			if (m[i]>=94) m[i] = m[i] + 1;
			if (m[i]>=123) m[i] = m[i] + 1;
		}
		fprintf(tmpf,"%s",m);
		if(15*((k+1)/15)==k+1) fprintf(tmpf,"\n");
	}
	if(15*((npt)/15)!=npt) fprintf(tmpf,"\n");
}
void compress(FILE *tmpf,float **array,int nx,int ny){//how it should be done
	for(int i=0; i<nx; i++) compress(tmpf,array[i],ny);
}
void compress(FILE *tmpf,float ***array,int nx,int ny,int nz){//might be compres3
	for(int i=0; i<nx; i++) compress(tmpf,array[i],ny,nz);
}
bool decompress(FILE *tmpf,float *xg,int npt)
{
	float expon,at2t23= 8388608.;
	long int i1=90,i,j,k,line,nline,nread=0;
	unsigned char lin[80],m[5];
	unsigned int np,kp;

	nline=npt/15;
	if(15*nline!=npt) nline=nline+1;
	for(line=0;line<nline;line++){
		//fscanf(tmpf,"%s",lin);//
		if(1!=fscanf(tmpf,"%s",lin)) break;
		nread=line+1;
		np=strlen((char*)lin)/5;
		if((5*np)!=strlen((char*)lin)) np=np+1;
		for(kp=0;kp<np;kp++){
			k=line*15+kp;
			for(i = 0;i<5;i++){
				m[i] = lin[5*kp+i];
				if (m[i]>=124) m[i] = m[i] - 1;
				if (m[i]>=95) m[i] = m[i] - 1;
				m[i] = m[i] - 33;}
			if (m[4]==80)
				xg[k] = 0.;
			else{
				if (m[4]>=40){
					m[4] = m[4] - 40;
					xg[k] = -1.;}
				else xg[k] = 1.;
				j = m[4]/12;
				m[4] = m[4] - j*12;
				expon=j*i1+m[3]-129;
				xg[k]=xg[k]*((((m[4]*i1+m[2])*i1+m[1])*i1
					      +m[0])/at2t23+ 1.);
				if (expon>0.)
					xg[k]=xg[k]*pow(2.,expon);
				else
					xg[k]=xg[k]/pow(2.,-expon);
			}
		}
	}
	if(nread<line) return false; else return true;
}
bool decompress(FILE *tmpf,float **array,int nx,int ny){
	bool res=true;
	for(int i=0; i<nx; i++) res=res && decompress(tmpf,array[i],ny);
	return res;
}
bool decompress(FILE *tmpf,float ***array,int nx,int ny,int nz){
	bool res=true;
	for(int i=0; i<nx; i++) res=res && decompress(tmpf,array[i],ny,nz);
	return res;
}
